"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _fs = _interopRequireDefault(require("fs"));

var _os = _interopRequireDefault(require("os"));

var _path = _interopRequireDefault(require("path"));

var _server = _interopRequireDefault(require("./server"));

// Check for ~/.log.io/server.json
var homedirConfigPath = _path["default"].resolve(_os["default"].homedir(), '.log.io/server.json');

var homedirConfigPathExists = _fs["default"].existsSync(homedirConfigPath);

var CONFIG_PATH = process.env.LOGIO_SERVER_CONFIG_PATH || homedirConfigPathExists && homedirConfigPath || _path["default"].resolve(__dirname, '../config.json');

function loadConfig(configPath) {
  return JSON.parse(_fs["default"].readFileSync(configPath, {
    encoding: 'utf8'
  }));
}

(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
  var config;
  return _regenerator["default"].wrap(function _callee$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return loadConfig(CONFIG_PATH);

        case 2:
          config = _context.sent;
          _context.next = 5;
          return (0, _server["default"])(config);

        case 5:
        case "end":
          return _context.stop();
      }
    }
  }, _callee);
}))()["catch"](function (e) {
  // eslint-disable-next-line no-console
  console.error(e);
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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