"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputName = getInputName;
exports["default"] = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

/**
 * Get string name of provided input
 */
function getInputName(streamName, sourceName) {
  return "".concat(streamName, "|").concat(sourceName);
}
/**
 * Maintains list of registered inputs
 */


var InputRegistry = /*#__PURE__*/function () {
  function InputRegistry() {
    (0, _classCallCheck2["default"])(this, InputRegistry);
    (0, _defineProperty2["default"])(this, "inputs", void 0);
    this.inputs = {};
  }

  (0, _createClass2["default"])(InputRegistry, [{
    key: "add",
    value: function add(streamName, sourceName) {
      var inputName = getInputName(streamName, sourceName);
      this.inputs[inputName] = true;
      return inputName;
    }
  }, {
    key: "remove",
    value: function remove(streamName, sourceName) {
      var inputName = getInputName(streamName, sourceName);
      delete this.inputs[inputName];
      return inputName;
    }
  }, {
    key: "getInputs",
    value: function getInputs() {
      return Object.keys(this.inputs).map(function (inputName) {
        var _inputName$split = inputName.split('|'),
            _inputName$split2 = (0, _slicedToArray2["default"])(_inputName$split, 2),
            stream = _inputName$split2[0],
            source = _inputName$split2[1];

        return {
          stream: stream,
          source: source,
          inputName: inputName
        };
      });
    }
  }]);
  return InputRegistry;
}();

var _default = InputRegistry;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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