/// <reference types="socket.io" />
import InputRegistry from './inputs';
export declare type ServerConfig = {
    messageServer: {
        port: number;
        host: string;
    };
    httpServer: {
        port: number;
        host: string;
    };
    debug?: boolean;
    basicAuth?: {
        realm: string;
        users: {
            [username: string]: string;
        };
    };
};
export declare type MessageHandlerFunction = (config: ServerConfig, inputs: InputRegistry, io: SocketIO.Server, msgParts: Array<string>) => Promise<void>;
export declare type MessageHandlers = {
    [messageType: string]: MessageHandlerFunction;
};
