//class AsyncLock { // https://medium.com/@chris_marois/asynchronous-locks-in-modern-javascript-8142c877baf
//    constructor () {
//      this.disable = () => {}
//      this.promise = Promise.resolve()
//    }
//  
//    enable () {
//      this.promise = new Promise(resolve => this.disable = resolve)
//    }
//}
//
//class Mutex {
//    constructor() {
//        this.locked = false;
//        this.queue = [];
//    }
//
//    lock() {
//        const unlock = () => {
//            this.locked = false;
//            if (this.queue.length > 0) {
//                const nextResolve = this.queue.shift();
//                nextResolve(unlock);
//            }
//        };
//
//        if (this.locked) {
//            return new Promise(resolve => this.queue.push(resolve));
//        } else {
//            this.locked = true;
//            return Promise.resolve(unlock);
//        }
//    }
//}


// Debugging Utility Functions
function console_log_error(msg) { console.log(`\u001b[31m${msg}\u001b[37m`); }
function console_log_warn(msg) { console.log(`\u001b[33m${msg}\u001b[37m`); }
function console_log_ok(msg) { console.log(`\u001b[32m${msg}\u001b[37m`); }
function console_log_blue(msg) { console.log(`\u001b[34m${msg}\u001b[37m`); }
function console_log_magenta(msg) { console.log(`\u001b[35m${msg}\u001b[37m`); }
function console_log_cyan(msg) { console.log(`\u001b[36m${msg}\u001b[37m`); }

const logLevels = {
    Extreme: 0,
    Debug: 1,
    Verbose: 2,
    Info: 3,
    Warning: 4,
    Error: 5,
    Off: 6
}

const getLogLevelName = (value) => {
    return Object.keys(logLevels).find(key => logLevels[key] === value);
}

module.exports = { console_log_error, console_log_ok, console_log_blue, console_log_magenta, console_log_warn, console_log_cyan, logLevels, getLogLevelName };
