/**
 * Get string name of provided input
 */
export declare function getInputName(streamName: string, sourceName: string): string;
/**
 * Maintains list of registered inputs
 */
declare class InputRegistry {
    inputs: {
        [inputName: string]: boolean;
    };
    constructor();
    add(streamName: string, sourceName: string): string;
    remove(streamName: string, sourceName: string): string;
    getInputs(): Array<{
        stream: string;
        source: string;
        inputName: string;
    }>;
}
export default InputRegistry;
