"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _express = _interopRequireDefault(require("express"));

var _expressBasicAuth = _interopRequireDefault(require("express-basic-auth"));

var _http = _interopRequireDefault(require("http"));

var _net = _interopRequireDefault(require("net"));

var _path = _interopRequireDefault(require("path"));

var _socket = _interopRequireDefault(require("socket.io"));

var _inputs = _interopRequireDefault(require("./inputs"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

// File path to UI app build artifacts (static JS/CSS/HTML)
var UI_BUILD_PATH = process.env.LOGIO_SERVER_UI_BUILD_PATH || _path["default"].resolve(__dirname, 'ui');
/**
 * Broadcast an inbound message to socket.io channels
 */


function handleNewMessage(_x, _x2, _x3, _x4) {
  return _handleNewMessage.apply(this, arguments);
}
/**
 * Broadcast a new input coming online to all browsers
 */


function _handleNewMessage() {
  _handleNewMessage = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(config, inputs, io, msgParts) {
    var _msgParts$slice, _msgParts$slice2, mtype, stream, source, msg, inputName;

    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _msgParts$slice = msgParts.slice(0, 3), _msgParts$slice2 = (0, _slicedToArray2["default"])(_msgParts$slice, 3), mtype = _msgParts$slice2[0], stream = _msgParts$slice2[1], source = _msgParts$slice2[2];
            msg = msgParts.slice(3).join('|');
            inputName = inputs.add(stream, source); // Broadcast message to input channel

            io.to(inputName).emit(mtype, {
              inputName: inputName,
              msg: msg,
              stream: stream,
              source: source
            }); // Broadcast ping to all browsers

            io.emit('+ping', {
              inputName: inputName,
              stream: stream,
              source: source
            });

            if (config.debug) {
              // eslint-disable-next-line no-console
              console.log(msgParts.join('|'));
            }

          case 6:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _handleNewMessage.apply(this, arguments);
}

function handleRegisterInput(_x5, _x6, _x7, _x8) {
  return _handleRegisterInput.apply(this, arguments);
}
/**
 * Broadcast an input going offline to all browsers
 */


function _handleRegisterInput() {
  _handleRegisterInput = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(config, inputs, io, msgParts) {
    var _msgParts$slice3, _msgParts$slice4, mtype, stream, source, inputName;

    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _msgParts$slice3 = msgParts.slice(0, 3), _msgParts$slice4 = (0, _slicedToArray2["default"])(_msgParts$slice3, 3), mtype = _msgParts$slice4[0], stream = _msgParts$slice4[1], source = _msgParts$slice4[2];
            inputName = inputs.add(stream, source);
            io.emit(mtype, {
              stream: stream,
              source: source,
              inputName: inputName
            });

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _handleRegisterInput.apply(this, arguments);
}

function handleDeregisterInput(_x9, _x10, _x11, _x12) {
  return _handleDeregisterInput.apply(this, arguments);
} // Maps TCP message prefix to handler function


function _handleDeregisterInput() {
  _handleDeregisterInput = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(config, inputs, io, msgParts) {
    var _msgParts$slice5, _msgParts$slice6, mtype, stream, source, inputName;

    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _msgParts$slice5 = msgParts.slice(0, 3), _msgParts$slice6 = (0, _slicedToArray2["default"])(_msgParts$slice5, 3), mtype = _msgParts$slice6[0], stream = _msgParts$slice6[1], source = _msgParts$slice6[2];
            inputName = inputs.remove(stream, source);
            io.emit(mtype, {
              stream: stream,
              source: source,
              inputName: inputName
            });

          case 3:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _handleDeregisterInput.apply(this, arguments);
}

var messageHandlers = {
  '+msg': handleNewMessage,
  '+input': handleRegisterInput,
  '-input': handleDeregisterInput
};
/**
 * Broadcast an inbound message to socket.io channels
 */

function broadcastMessage(_x13, _x14, _x15, _x16) {
  return _broadcastMessage.apply(this, arguments);
}
/**
 * Start message & web servers
 */


function _broadcastMessage() {
  _broadcastMessage = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(config, inputs, io, data) {
    var msgs;
    return _regenerator["default"].wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            // Parse raw message into parts
            // NOTE: After split on null termination character, last item will always
            // be either an empty string or a partial/incomplete message
            msgs = data.toString().split('\0').slice(0, -1).filter(function (msg) {
              return !!msg.trim();
            });
            msgs.forEach( /*#__PURE__*/function () {
              var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(msg) {
                var msgParts, messageHandler;
                return _regenerator["default"].wrap(function _callee4$(_context4) {
                  while (1) {
                    switch (_context4.prev = _context4.next) {
                      case 0:
                        msgParts = msg.split('|');
                        messageHandler = messageHandlers[msgParts[0]];

                        if (!messageHandler) {
                          _context4.next = 7;
                          break;
                        }

                        _context4.next = 5;
                        return messageHandler(config, inputs, io, msgParts);

                      case 5:
                        _context4.next = 8;
                        break;

                      case 7:
                        // eslint-disable-next-line no-console
                        console.error("Unknown message type: ".concat(msgParts[0]));

                      case 8:
                      case "end":
                        return _context4.stop();
                    }
                  }
                }, _callee4);
              }));

              return function (_x18) {
                return _ref.apply(this, arguments);
              };
            }());

          case 2:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  }));
  return _broadcastMessage.apply(this, arguments);
}

function main(_x17) {
  return _main.apply(this, arguments);
}

function _main() {
  _main = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee9(config) {
    var server, httpServer, io, inputs, messageServer;
    return _regenerator["default"].wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            // Create HTTP server w/ static file serving, socket.io bindings & basic auth
            server = (0, _express["default"])();
            httpServer = new _http["default"].Server(server);
            io = (0, _socket["default"])(httpServer);
            inputs = new _inputs["default"]();

            if (config.basicAuth) {
              if (config.basicAuth.users && config.basicAuth.realm) {
                server.use((0, _expressBasicAuth["default"])(_objectSpread({}, config.basicAuth, {
                  challenge: true
                })));
              } else {
                // eslint-disable-next-line no-console
                console.warn("\nWARNING: Unable to enable basic authentication.\n\nBasic auth configuration requires the following keys: 'users', 'realm'.\n\nSee README for more examples.\n      ");
              }
            }

            server.use('/', _express["default"]["static"](UI_BUILD_PATH)); // Create TCP message server

            messageServer = _net["default"].createServer( /*#__PURE__*/function () {
              var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(socket) {
                return _regenerator["default"].wrap(function _callee7$(_context7) {
                  while (1) {
                    switch (_context7.prev = _context7.next) {
                      case 0:
                        socket.on('data', /*#__PURE__*/function () {
                          var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6(data) {
                            return _regenerator["default"].wrap(function _callee6$(_context6) {
                              while (1) {
                                switch (_context6.prev = _context6.next) {
                                  case 0:
                                    _context6.next = 2;
                                    return broadcastMessage(config, inputs, io, data);

                                  case 2:
                                  case "end":
                                    return _context6.stop();
                                }
                              }
                            }, _callee6);
                          }));

                          return function (_x20) {
                            return _ref3.apply(this, arguments);
                          };
                        }());

                      case 1:
                      case "end":
                        return _context7.stop();
                    }
                  }
                }, _callee7);
              }));

              return function (_x19) {
                return _ref2.apply(this, arguments);
              };
            }()); // When a new browser connects, register stream activation events

            io.on('connection', /*#__PURE__*/function () {
              var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee8(socket) {
                return _regenerator["default"].wrap(function _callee8$(_context8) {
                  while (1) {
                    switch (_context8.prev = _context8.next) {
                      case 0:
                        // Send existing inputs to browser
                        inputs.getInputs().forEach(function (input) {
                          socket.emit('+input', input);
                        }); // Register input activation events

                        socket.on('+activate', function (inputName) {
                          socket.join(inputName);
                        });
                        socket.on('-activate', function (inputName) {
                          socket.leave(inputName);
                        });

                      case 3:
                      case "end":
                        return _context8.stop();
                    }
                  }
                }, _callee8);
              }));

              return function (_x21) {
                return _ref4.apply(this, arguments);
              };
            }()); // Start listening for requests

            messageServer.listen(config.messageServer.port, config.messageServer.host, function () {
              // eslint-disable-next-line no-console
              console.log("TCP message server listening on port ".concat(config.messageServer.port));
            });
            httpServer.listen(config.httpServer.port, config.httpServer.host, function () {
              // eslint-disable-next-line no-console
              console.log("HTTP server listening on port ".concat(config.httpServer.port));
            });

          case 10:
          case "end":
            return _context9.stop();
        }
      }
    }, _callee9);
  }));
  return _main.apply(this, arguments);
}

var _default = main;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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