#!/bin/bash
#Run as sudo, time will tell if this is a good strategy

tmpUpdateFilePath="/etc/vega"
#delete any old updates
echo "Removing old deb packages"
rm -f "$tmpUpdateFilePath/*.deb"
rm -f "$tmpUpdateFilePath/*.tar.gz"

if [ -e "/dev/sda1" ]; then
	echo "USB Found"

	# Try to mount a USB thumb drive
	if [ ! -d "/mnt/usb1" ]; then
		mkdir /mnt/usb1/
	fi
	mount /dev/sda1 /mnt/usb1 -o fmask=0000,dmask=0000
	#check if there is an update file on the thumb drive
	if [ -e "/mnt/usb1/dakupdate.tar.gz" ]; then
		echo "Local Update Found"

		#unzip and decrypt the update (TODO: add back in the decrypt step if we ever decide to encrypt our update files)
		#openssl smime -decrypt -in /mnt/usb1/dakupdate.tar.gz -binary -inform DEM -inkey /home/daktronics/update/privatekey.pem -out /home/daktronics/update/new/dakupdate_dec.tar.gz
		cp /mnt/usb1/dakupdate.tar.gz $tmpUpdateFilePath/dakupdate.tar.gz
		tar xzf $tmpUpdateFilePath/dakupdate.tar.gz -C $tmpUpdateFilePath
		
		umount /mnt/usb1
	else
		echo "Failed to Find Local Update"
	fi
else
	echo "USB Not Found"
fi