import json

def update_fl5_products(filename="/var/lib/vega/fl5/fl5_products"):
    try:
        with open(filename, 'r') as file:
            data = json.load(file)
        # Check if 'products' key exists
        if 'products' not in data:
            print(f"Warning: 'products' key not found in {filename}")
            return

        if not isinstance(data['products'], list):
            print(f"Warning: 'products' value is not an array in {filename}")
            return

        # Track changes made
        changes_made = 0

        # Iterate through each product dictionary
        for i, product in enumerate(data['products']):
            if not isinstance(product, dict):
                print(f"Warning: Product at index {i} is not a dictionary")
                continue

            # Add pctOffset field if missing
            if 'pctOffset' not in product:
                product['pctOffset'] = "0"
                changes_made += 1
                print(f"Added 'pctOffset': '0' to product at index {i}")

            # Add negPctOffset field if missing
            if 'negPctOffset' not in product:
                product['negPctOffset'] = False
                changes_made += 1
                print(f"Added 'negPctOffset': False to product at index {i}")

        # Write the updated data back to the file
        if changes_made > 0:
            with open(filename, 'w') as file:
                json.dump(data, file, indent=2)
            print(f"\nUpdated {filename} with {changes_made} field additions")
        else:
            print(f"\nNo changes needed for {filename}")

    except FileNotFoundError:
        print(f"Error: File '{filename}' not found")
    except json.JSONDecodeError as e:
        print(f"Error: Invalid JSON in file '{filename}': {e}")
    except Exception as e:
        print(f"Error: {e}")

if __name__ == "__main__":
    update_fl5_products("/var/lib/vega/fl5/fl5_products")
