const { execSync } = require('child_process');
const fs = require('fs');

const netDir = '/sys/class/net'

setTimeout(() => {
  const fileNames = fs.readdirSync(netDir);

  console.log("Reconfiguring network settings");
  console.log("Reloading daemon");
  execSync('sudo systemctl daemon-reload');
  console.log("Stopping dhcpcd");

  execSync('sudo systemctl stop dhcpcd.service');

  console.log("Flushing network devices");
  for (let idx = 0; idx < fileNames.length; ++idx) {
      if (fileNames[idx].includes("eth")) {
          console.log(`Flushing ${fileNames[idx]}`);
          execSync(`sudo ip addr flush dev ${fileNames[idx]}`);
      }
  }

  console.log("Starting dhcpcd");
  execSync('sudo systemctl start dhcpcd.service');
  console.log("Restarting networking");
  execSync('sudo systemctl restart networking.service');
}, 2000)
